<?php
require_once 'config.php';
requireLogin();

$conn = getDBConnection();

// Get available years
$result = $conn->query("SELECT DISTINCT YEAR(periodo) as year FROM liquidaciones ORDER BY year DESC");
$years = [];
while ($row = $result->fetch_assoc()) {
    $years[] = $row['year'];
}

// Get date range
$result = $conn->query("SELECT MIN(periodo) as min_date, MAX(periodo) as max_date FROM liquidaciones");
$dateRange = $result->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reportes - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <?php include 'header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h1>Reportes de Liquidaciones</h1>
        </div>
        
        <div class="reports-grid">
            <!-- Monthly Report -->
            <div class="report-card">
                <h2>Reporte Mensual</h2>
                <p>Exportar liquidaciones de un mes específico</p>
                <form action="export_excel.php" method="GET">
                    <input type="hidden" name="type" value="monthly">
                    
                    <div class="form-group">
                        <label for="month">Mes</label>
                        <select id="month" name="month" required>
                            <option value="01">Enero</option>
                            <option value="02">Febrero</option>
                            <option value="03">Marzo</option>
                            <option value="04">Abril</option>
                            <option value="05">Mayo</option>
                            <option value="06">Junio</option>
                            <option value="07">Julio</option>
                            <option value="08">Agosto</option>
                            <option value="09">Septiembre</option>
                            <option value="10">Octubre</option>
                            <option value="11">Noviembre</option>
                            <option value="12">Diciembre</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="year_monthly">Año</label>
                        <select id="year_monthly" name="year" required>
                            <?php foreach ($years as $year): ?>
                                <option value="<?php echo $year; ?>"><?php echo $year; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <button type="submit" class="btn btn-success btn-block">Descargar Excel</button>
                </form>
            </div>
            
            <!-- Date Range Report -->
            <div class="report-card">
                <h2>Reporte por Rango de Fechas</h2>
                <p>Exportar liquidaciones entre dos fechas</p>
                <form action="export_excel.php" method="GET">
                    <input type="hidden" name="type" value="range">
                    
                    <div class="form-group">
                        <label for="date_from">Desde</label>
                        <input type="date" id="date_from" name="date_from" required
                               value="<?php echo $dateRange['min_date'] ?? ''; ?>">
                    </div>
                    
                    <div class="form-group">
                        <label for="date_to">Hasta</label>
                        <input type="date" id="date_to" name="date_to" required
                               value="<?php echo $dateRange['max_date'] ?? ''; ?>">
                    </div>
                    
                    <button type="submit" class="btn btn-success btn-block">Descargar Excel</button>
                </form>
            </div>
            
            <!-- Yearly Report -->
            <div class="report-card">
                <h2>Reporte Anual</h2>
                <p>Exportar todas las liquidaciones de un año (tabla por meses)</p>
                <form action="export_excel.php" method="GET">
                    <input type="hidden" name="type" value="yearly">
                    
                    <div class="form-group">
                        <label for="year_annual">Año</label>
                        <select id="year_annual" name="year" required>
                            <?php foreach ($years as $year): ?>
                                <option value="<?php echo $year; ?>"><?php echo $year; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <button type="submit" class="btn btn-success btn-block">Descargar Excel</button>
                </form>
            </div>
        </div>
    </div>
</body>
</html>
