<?php
require_once 'config.php';
requireLogin();

$conn = getDBConnection();

$isEdit = isset($_GET['id']);
$person = null;
$errors = [];

if ($isEdit) {
    $id = intval($_GET['id']);
    $stmt = $conn->prepare("SELECT * FROM people WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $person = $stmt->get_result()->fetch_assoc();
    
    if (!$person) {
        header('Location: people.php');
        exit;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $dni = trim($_POST['dni'] ?? '');
    $legajo = trim($_POST['legajo'] ?? '');
    
    // Validation
    if (empty($name)) $errors[] = 'El nombre es requerido';
    if (empty($dni)) $errors[] = 'El DNI es requerido';
    if (empty($legajo)) $errors[] = 'El legajo es requerido';
    
    if (empty($errors)) {
        if ($isEdit) {
            $stmt = $conn->prepare("UPDATE people SET name = ?, dni = ?, legajo = ? WHERE id = ?");
            $stmt->bind_param("sssi", $name, $dni, $legajo, $id);
            $stmt->execute();
            header('Location: people.php?msg=updated');
        } else {
            $stmt = $conn->prepare("INSERT INTO people (name, dni, legajo) VALUES (?, ?, ?)");
            $stmt->bind_param("sss", $name, $dni, $legajo);
            $stmt->execute();
            header('Location: people.php?msg=added');
        }
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $isEdit ? 'Editar' : 'Agregar'; ?> Persona - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <?php include 'header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h1><?php echo $isEdit ? 'Editar' : 'Agregar Nueva'; ?> Persona</h1>
        </div>
        
        <?php if (!empty($errors)): ?>
            <div class="alert alert-error">
                <ul>
                    <?php foreach ($errors as $error): ?>
                        <li><?php echo htmlspecialchars($error); ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php endif; ?>
        
        <form method="POST" class="form-container">
            <div class="form-group">
                <label for="name">Nombre Completo *</label>
                <input type="text" id="name" name="name" required 
                       value="<?php echo htmlspecialchars($person['name'] ?? ''); ?>">
            </div>
            
            <div class="form-group">
                <label for="dni">DNI *</label>
                <input type="text" id="dni" name="dni" required 
                       value="<?php echo htmlspecialchars($person['dni'] ?? ''); ?>">
            </div>
            
            <div class="form-group">
                <label for="legajo">Legajo *</label>
                <input type="text" id="legajo" name="legajo" required 
                       value="<?php echo htmlspecialchars($person['legajo'] ?? ''); ?>">
            </div>
            
            <div class="form-actions">
                <button type="submit" class="btn btn-primary">
                    <?php echo $isEdit ? 'Actualizar' : 'Guardar'; ?>
                </button>
                <a href="people.php" class="btn btn-secondary">Cancelar</a>
            </div>
        </form>
    </div>
</body>
</html>
