<?php
require_once 'config.php';
requireLogin();

$conn = getDBConnection();

// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM people WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    header('Location: people.php?msg=deleted');
    exit;
}

// Get all people
$result = $conn->query("SELECT * FROM people ORDER BY name ASC");
$people = $result->fetch_all(MYSQLI_ASSOC);

$message = '';
if (isset($_GET['msg'])) {
    switch ($_GET['msg']) {
        case 'added':
            $message = 'Persona agregada exitosamente';
            break;
        case 'updated':
            $message = 'Persona actualizada exitosamente';
            break;
        case 'deleted':
            $message = 'Persona eliminada exitosamente';
            break;
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Personas - <?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <?php include 'header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h1>Gestión de Personas</h1>
            <a href="people_form.php" class="btn btn-primary">Agregar Nueva Persona</a>
        </div>
        
        <?php if ($message): ?>
            <div class="alert alert-success"><?php echo $message; ?></div>
        <?php endif; ?>
        
        <table class="data-table">
            <thead>
                <tr>
                    <th>Nombre</th>
                    <th>DNI</th>
                    <th>Legajo</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($people as $person): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($person['name']); ?></td>
                        <td><?php echo htmlspecialchars($person['dni']); ?></td>
                        <td><?php echo htmlspecialchars($person['legajo']); ?></td>
                        <td>
                            <a href="people_form.php?id=<?php echo $person['id']; ?>" class="btn btn-sm btn-secondary">Editar</a>
                            <a href="people.php?delete=<?php echo $person['id']; ?>" 
                               class="btn btn-sm btn-danger" 
                               onclick="return confirm('¿Está seguro de eliminar esta persona?')">Eliminar</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                
                <?php if (empty($people)): ?>
                    <tr>
                        <td colspan="4" style="text-align: center;">No hay personas registradas</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
