document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('liquidacionesForm');
    const btnSave = document.getElementById('btnSave');
    const btnEdit = document.getElementById('btnEdit');
    const inputs = document.querySelectorAll('.input-monto');
    
    // Enable editing
    if (btnEdit) {
        btnEdit.addEventListener('click', function() {
            inputs.forEach(input => input.removeAttribute('readonly'));
            btnEdit.style.display = 'none';
            btnSave.style.display = 'inline-block';
            btnSave.textContent = 'Confirmar y Guardar Cambios';
        });
    }
    
    // Form submission
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        if (!confirm('¿Está seguro de guardar estas liquidaciones?')) {
            return;
        }
        
        btnSave.disabled = true;
        btnSave.textContent = 'Guardando...';
        
        const formData = new FormData(form);
        
        fetch('api_save_liquidaciones.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showNotification('Liquidaciones guardadas exitosamente', 'success');
                
                // Lock inputs
                inputs.forEach(input => input.setAttribute('readonly', 'readonly'));
                
                // Change buttons
                btnSave.style.display = 'none';
                if (btnEdit) {
                    btnEdit.style.display = 'inline-block';
                } else {
                    const newBtnEdit = document.createElement('button');
                    newBtnEdit.type = 'button';
                    newBtnEdit.id = 'btnEdit';
                    newBtnEdit.className = 'btn btn-warning';
                    newBtnEdit.textContent = 'Habilitar Edición';
                    newBtnEdit.addEventListener('click', function() {
                        inputs.forEach(input => input.removeAttribute('readonly'));
                        newBtnEdit.style.display = 'none';
                        btnSave.style.display = 'inline-block';
                        btnSave.textContent = 'Confirmar y Guardar Cambios';
                    });
                    btnSave.parentNode.insertBefore(newBtnEdit, btnSave);
                }
            } else {
                showNotification(data.message || 'Error al guardar', 'error');
            }
        })
        .catch(error => {
            showNotification('Error de conexión', 'error');
        })
        .finally(() => {
            btnSave.disabled = false;
            btnSave.textContent = 'Confirmar y Guardar Cambios';
        });
    });
    
    // Input validation
    inputs.forEach(input => {
        input.addEventListener('input', function() {
            if (this.value < 0) {
                this.value = 0;
            }
        });
    });
});

function showNotification(message, type) {
    const notification = document.getElementById('notification');
    notification.textContent = message;
    notification.className = 'notification notification-' + type;
    notification.style.display = 'block';
    
    setTimeout(() => {
        notification.style.display = 'none';
    }, 5000);
}
