<?php
require_once 'config.php';
requireLogin();

// Calculate current and previous month
$currentDate = new DateTime();
$previousMonth = clone $currentDate;
$previousMonth->modify('-1 month');
$previousMonth->modify('first day of this month');

$periodoActual = $previousMonth->format('Y-m-d');
$periodoDisplay = $previousMonth->format('F Y');
$periodoDisplayES = strftime('%B %Y', $previousMonth->getTimestamp());

// Get all people ordered by name
$conn = getDBConnection();
$stmt = $conn->prepare("SELECT id, name, dni, legajo FROM people ORDER BY name ASC");
$stmt->execute();
$people = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// Check if current period already has data
$stmt = $conn->prepare("SELECT persona_id, monto FROM liquidaciones WHERE periodo = ?");
$stmt->bind_param("s", $periodoActual);
$stmt->execute();
$result = $stmt->get_result();

$existingData = [];
while ($row = $result->fetch_assoc()) {
    $existingData[$row['persona_id']] = $row['monto'];
}

$isLocked = !empty($existingData);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo APP_NAME; ?></title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <?php include 'header.php'; ?>
    
    <div class="container">
        <div class="page-header">
            <h1>Carga de Liquidaciones</h1>
            <h2 class="periodo-title">Período: <?php echo ucfirst($periodoDisplayES); ?></h2>
        </div>
        
        <div id="notification" class="notification" style="display: none;"></div>
        
        <form id="liquidacionesForm">
            <input type="hidden" name="periodo" value="<?php echo $periodoActual; ?>">
            
            <table class="data-table">
                <thead>
                    <tr>
                        <th>Nombre</th>
                        <th>DNI</th>
                        <th>Legajo</th>
                        <th>Monto</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($people as $person): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($person['name']); ?></td>
                            <td><?php echo htmlspecialchars($person['dni']); ?></td>
                            <td><?php echo htmlspecialchars($person['legajo']); ?></td>
                            <td>
                                <input 
                                    type="number" 
                                    name="montos[<?php echo $person['id']; ?>]" 
                                    step="0.01" 
                                    min="0"
                                    class="input-monto"
                                    value="<?php echo isset($existingData[$person['id']]) ? $existingData[$person['id']] : ''; ?>"
                                    <?php echo $isLocked ? 'readonly' : ''; ?>
                                >
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <div class="form-actions">
                <?php if ($isLocked): ?>
                    <button type="button" id="btnEdit" class="btn btn-warning">Habilitar Edición</button>
                    <button type="submit" id="btnSave" class="btn btn-primary" style="display: none;">Confirmar y Guardar Cambios</button>
                <?php else: ?>
                    <button type="submit" id="btnSave" class="btn btn-primary">Confirmar y Guardar Liquidaciones</button>
                <?php endif; ?>
            </div>
        </form>
    </div>
    
    <script src="liquidaciones.js"></script>
</body>
</html>
