<?php
require_once 'config.php';
requireLogin();

$type = $_GET['type'] ?? '';

if (!in_array($type, ['monthly', 'range', 'yearly'])) {
    die('Invalid report type');
}

$conn = getDBConnection();

// Generate Excel file
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment; filename="liquidaciones_' . date('Y-m-d_His') . '.xls"');
header('Pragma: no-cache');
header('Expires: 0');

echo "\xEF\xBB\xBF"; // UTF-8 BOM

if ($type === 'monthly') {
    $month = $_GET['month'] ?? '';
    $year = $_GET['year'] ?? '';
    
    $periodo = "$year-$month-01";
    
    $stmt = $conn->prepare("
        SELECT p.name, p.dni, p.legajo, l.monto
        FROM people p
        LEFT JOIN liquidaciones l ON p.id = l.persona_id AND l.periodo = ?
        ORDER BY p.name ASC
    ");
    $stmt->bind_param("s", $periodo);
    $stmt->execute();
    $result = $stmt->get_result();
    
    echo "<table border='1'>";
    echo "<tr><th colspan='4' style='text-align:center; font-weight:bold;'>Liquidaciones - " . date('F Y', strtotime($periodo)) . "</th></tr>";
    echo "<tr><th>Nombre</th><th>DNI</th><th>Legajo</th><th>Monto</th></tr>";
    
    $total = 0;
    while ($row = $result->fetch_assoc()) {
        $monto = $row['monto'] ?? 0;
        $total += $monto;
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['name']) . "</td>";
        echo "<td>" . htmlspecialchars($row['dni']) . "</td>";
        echo "<td>" . htmlspecialchars($row['legajo']) . "</td>";
        echo "<td>" . number_format($monto, 2, ',', '.') . "</td>";
        echo "</tr>";
    }
    
    echo "<tr><td colspan='3' style='text-align:right; font-weight:bold;'>TOTAL:</td>";
    echo "<td style='font-weight:bold;'>" . number_format($total, 2, ',', '.') . "</td></tr>";
    echo "</table>";
    
} elseif ($type === 'range') {
    $dateFrom = $_GET['date_from'] ?? '';
    $dateTo = $_GET['date_to'] ?? '';
    
    $stmt = $conn->prepare("
        SELECT p.name, p.dni, p.legajo, l.periodo, l.monto
        FROM liquidaciones l
        JOIN people p ON l.persona_id = p.id
        WHERE l.periodo BETWEEN ? AND ?
        ORDER BY l.periodo ASC, p.name ASC
    ");
    $stmt->bind_param("ss", $dateFrom, $dateTo);
    $stmt->execute();
    $result = $stmt->get_result();
    
    echo "<table border='1'>";
    echo "<tr><th colspan='5' style='text-align:center; font-weight:bold;'>Liquidaciones desde " . date('d/m/Y', strtotime($dateFrom)) . " hasta " . date('d/m/Y', strtotime($dateTo)) . "</th></tr>";
    echo "<tr><th>Período</th><th>Nombre</th><th>DNI</th><th>Legajo</th><th>Monto</th></tr>";
    
    $total = 0;
    while ($row = $result->fetch_assoc()) {
        $total += $row['monto'];
        echo "<tr>";
        echo "<td>" . date('m/Y', strtotime($row['periodo'])) . "</td>";
        echo "<td>" . htmlspecialchars($row['name']) . "</td>";
        echo "<td>" . htmlspecialchars($row['dni']) . "</td>";
        echo "<td>" . htmlspecialchars($row['legajo']) . "</td>";
        echo "<td>" . number_format($row['monto'], 2, ',', '.') . "</td>";
        echo "</tr>";
    }
    
    echo "<tr><td colspan='4' style='text-align:right; font-weight:bold;'>TOTAL:</td>";
    echo "<td style='font-weight:bold;'>" . number_format($total, 2, ',', '.') . "</td></tr>";
    echo "</table>";
    
} elseif ($type === 'yearly') {
    $year = $_GET['year'] ?? '';
    
    // Get all people
    $people = $conn->query("SELECT id, name, dni, legajo FROM people ORDER BY name ASC")->fetch_all(MYSQLI_ASSOC);
    
    // Get all liquidaciones for the year
    $stmt = $conn->prepare("
        SELECT persona_id, MONTH(periodo) as month, monto
        FROM liquidaciones
        WHERE YEAR(periodo) = ?
    ");
    $stmt->bind_param("s", $year);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $liquidaciones = [];
    while ($row = $result->fetch_assoc()) {
        $liquidaciones[$row['persona_id']][$row['month']] = $row['monto'];
    }
    
    echo "<table border='1'>";
    echo "<tr><th colspan='16' style='text-align:center; font-weight:bold;'>Liquidaciones Año " . $year . "</th></tr>";
    echo "<tr>";
    echo "<th>Nombre</th><th>DNI</th><th>Legajo</th>";
    $months = ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'];
    foreach ($months as $m) {
        echo "<th>$m</th>";
    }
    echo "<th>TOTAL</th>";
    echo "</tr>";
    
    $monthTotals = array_fill(1, 12, 0);
    $grandTotal = 0;
    
    foreach ($people as $person) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($person['name']) . "</td>";
        echo "<td>" . htmlspecialchars($person['dni']) . "</td>";
        echo "<td>" . htmlspecialchars($person['legajo']) . "</td>";
        
        $personTotal = 0;
        for ($m = 1; $m <= 12; $m++) {
            $monto = $liquidaciones[$person['id']][$m] ?? 0;
            $personTotal += $monto;
            $monthTotals[$m] += $monto;
            echo "<td>" . ($monto > 0 ? number_format($monto, 2, ',', '.') : '-') . "</td>";
        }
        
        $grandTotal += $personTotal;
        echo "<td style='font-weight:bold;'>" . number_format($personTotal, 2, ',', '.') . "</td>";
        echo "</tr>";
    }
    
    // Totals row
    echo "<tr style='font-weight:bold;'>";
    echo "<td colspan='3' style='text-align:right;'>TOTALES:</td>";
    for ($m = 1; $m <= 12; $m++) {
        echo "<td>" . number_format($monthTotals[$m], 2, ',', '.') . "</td>";
    }
    echo "<td>" . number_format($grandTotal, 2, ',', '.') . "</td>";
    echo "</tr>";
    
    echo "</table>";
}
?>
