-- Run this SQL to create the required tables

-- Table: people (may already exist)
CREATE TABLE IF NOT EXISTS people (
    id INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(255) NOT NULL,
    dni VARCHAR(50) NOT NULL,
    legajo VARCHAR(50) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_name (name)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Table: liquidaciones
CREATE TABLE IF NOT EXISTS liquidaciones (
    id INT PRIMARY KEY AUTO_INCREMENT,
    persona_id INT NOT NULL,
    monto DECIMAL(10, 2) NOT NULL,
    periodo DATE NOT NULL,
    fecha_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (persona_id) REFERENCES people(id) ON DELETE CASCADE,
    INDEX idx_periodo (periodo),
    INDEX idx_persona_periodo (persona_id, periodo)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
