<?php
require_once 'config.php';
requireLogin();

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$periodo = $_POST['periodo'] ?? '';
$montos = $_POST['montos'] ?? [];

if (empty($periodo)) {
    echo json_encode(['success' => false, 'message' => 'Período no especificado']);
    exit;
}

// Validate periodo format
if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $periodo)) {
    echo json_encode(['success' => false, 'message' => 'Formato de período inválido']);
    exit;
}

$conn = getDBConnection();

// Start transaction
$conn->begin_transaction();

try {
    // Delete existing records for this period
    $stmt = $conn->prepare("DELETE FROM liquidaciones WHERE periodo = ?");
    $stmt->bind_param("s", $periodo);
    $stmt->execute();
    
    // Insert new records
    $stmt = $conn->prepare("INSERT INTO liquidaciones (persona_id, monto, periodo) VALUES (?, ?, ?)");
    
    foreach ($montos as $personaId => $monto) {
        $monto = floatval($monto);
        
        if ($monto > 0) {
            $stmt->bind_param("ids", $personaId, $monto, $periodo);
            $stmt->execute();
        }
    }
    
    $conn->commit();
    
    echo json_encode(['success' => true, 'message' => 'Liquidaciones guardadas exitosamente']);
    
} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(['success' => false, 'message' => 'Error al guardar: ' . $e->getMessage()]);
}
?>
